using System;
using System.Data;
using System.Data.SqlClient;
using System.Data.SqlTypes;
using Microsoft.SqlServer.Server;
using System.Xml;
using System.Runtime.InteropServices;
using System.Collections;

public partial class UserDefinedFunctions{
    [Microsoft.SqlServer.Server.SqlFunction(IsDeterministic = false,
        DataAccess = DataAccessKind.None,
        TableDefinition = "title nvarchar(256) NULL, guid nvarchar(256) NULL, pubdate datetime, description nvarchar(max)",
        FillRowMethodName = "GetRow")
    ]
    public static IEnumerable getHelionRSS()
    {
        XmlTextReader xmlSource = new XmlTextReader("http://helion.pl/rss/rss.cgi");
        XmlDocument xmlDoc = new XmlDocument();
        xmlDoc.Load(xmlSource);
        xmlSource.Close();

        return xmlDoc.SelectNodes("//rss/channel/item");
    }

    private static void GetRow(object o, ref SqlString title,
        ref SqlString guid, ref SqlDateTime pubdate, ref SqlString description)
    {    
        XmlElement element = (XmlElement)o;

        if ((element.SelectSingleNode("./title") != null))
            title = element.SelectSingleNode("./title").InnerText;

        if (element.SelectSingleNode("./guid") != null)
            guid = element.SelectSingleNode("./guid").InnerText;

        if (element.SelectSingleNode("./pubDate") != null)
            pubdate = DateTime.Parse(element.SelectSingleNode("./pubDate").InnerText);

        if (element.SelectSingleNode("./description") != null)
            description = element.SelectSingleNode("./description").InnerText;
    }
};

